
import gurobipy as gp

# Create a new model
m = gp.Model("Julia's Diet")

# Create variables
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="Vanilla_Protein_Bars") # servings of protein bars
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="Organic_Meal_Replacement_Shakes") # servings of shakes


# Set objective function
m.setObjective(10*x1 + 15*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(30*x1 + 10*x2 >= 155, "Protein_Requirement")
m.addConstr(50*x1 + 20*x2 >= 140, "Carb_Requirement")
m.addConstr(2*x1 + 5*x2 <= 55, "Fat_Limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Vanilla Protein Bars: {x1.x:.2f} servings")
    print(f"Organic Meal Replacement Shakes: {x2.x:.2f} servings")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

