
from gurobipy import *

# Create a new model
m = Model("Julia_Diet")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="vanilla_protein_bars", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="organic_meal_replacement_shakes", lb=0)

# Set the objective function
m.setObjective(10*x1 + 15*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(30*x1 + 10*x2 >= 155, "protein_requirement")
m.addConstr(50*x1 + 20*x2 >= 140, "carb_requirement")
m.addConstr(2*x1 + 5*x2 <= 55, "fat_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vanilla protein bars: {x1.x}")
    print(f"Organic meal replacement shakes: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
