
import gurobi

def solve_julia_diet_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="vanilla_protein_bars", lb=0)
    x2 = model.addVar(name="organic_meal_replacement_shakes", lb=0)

    # Define the objective function
    model.setObjective(10 * x1 + 15 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(30 * x1 + 10 * x2 >= 155, name="protein_requirement")
    model.addConstr(50 * x1 + 20 * x2 >= 140, name="carbs_requirement")
    model.addConstr(2 * x1 + 5 * x2 <= 55, name="fat_limit")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Vanilla protein bars: {x1.varValue}")
        print(f"Organic meal replacement shakes: {x2.varValue}")
        print(f"Cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_julia_diet_problem()
