
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("theta_electronics")

# Create variables
keyboards = m.addVar(vtype=GRB.CONTINUOUS, name="keyboards")
controllers = m.addVar(vtype=GRB.CONTINUOUS, name="controllers")

# Set objective function
m.setObjective(20 * keyboards + 10 * controllers, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * keyboards + 4 * controllers <= 200, "floor_space")
m.addConstr(controllers >= 0.35 * (keyboards + controllers), "controller_proportion")
m.addConstr(200 * keyboards + 150 * controllers <= 5000, "capital")
m.addConstr(keyboards >= 0, "keyboards_nonnegative")
m.addConstr(controllers >= 0, "controllers_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of keyboards: {keyboards.x:.2f}")
    print(f"Number of PC controllers: {controllers.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

