
from gurobipy import *

# Create a new model
m = Model("Theta_Electronics")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="keyboards")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="PC_controllers")

# Set the objective function
m.setObjective(20*x1 + 10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x1 + 4*x2 <= 200, "floor_space")
m.addConstr(0.35*x1 <= 0.65*x2, "pc_controller_percentage")
m.addConstr(200*x1 + 150*x2 <= 5000, "capital")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Keyboards: {x1.x}")
    print(f"PC Controllers: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
