
import gurobipy as gp

# Create a new model
m = gp.Model("Theta_Electronics")

# Define the variables
x1 = m.addVar(name="keyboards", lb=0)
x2 = m.addVar(name="PC_controllers", lb=0)

# Define the objective function
m.setObjective(20*x1 + 10*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x1 + 4*x2 <= 200, name="floor_space")
m.addConstr(-0.35*x1 + 0.65*x2 >= 0, name="PC_controller_percentage")
m.addConstr(200*x1 + 150*x2 <= 5000, name="capital")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Keyboards: {x1.varValue}")
    print(f"PC Controllers: {x2.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
