
import gurobipy as gp

# Create a new model
model = gp.Model("Maximize Viewership")

# Create variables
diy_ads = model.addVar(vtype=gp.GRB.INTEGER, name="diy_ads")
shopping_ads = model.addVar(vtype=gp.GRB.INTEGER, name="shopping_ads")
unboxing_ads = model.addVar(vtype=gp.GRB.INTEGER, name="unboxing_ads")

# Set objective function
model.setObjective(10000 * diy_ads + 4000 * shopping_ads + 9000 * unboxing_ads, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5000 * diy_ads + 3200 * shopping_ads + 4000 * unboxing_ads <= 120000, "budget_constraint")
model.addConstr(diy_ads <= 5, "diy_limit")
model.addConstr(unboxing_ads <= 0.5 * (diy_ads + shopping_ads + unboxing_ads), "unboxing_proportion")
model.addConstr(shopping_ads >= 0.2 * (diy_ads + shopping_ads + unboxing_ads), "shopping_proportion")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of DIY ads: {diy_ads.x}")
    print(f"Number of Shopping ads: {shopping_ads.x}")
    print(f"Number of Unboxing ads: {unboxing_ads.x}")
    print(f"Total Viewership: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

