
import gurobi

def solve_ad_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # DIY videos
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # Shopping videos
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # Unboxing videos

    # Objective function: Maximize viewership
    model.setObjective(10000*x1 + 4000*x2 + 9000*x3, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(5000*x1 + 3200*x2 + 4000*x3 <= 120000)

    # Limit on DIY videos
    model.addConstr(x1 <= 5)

    # Limit on unboxing videos
    model.addConstr(x3 <= 0.5*(x1 + x2 + x3))

    # Minimum shopping videos
    model.addConstr(x2 >= 0.2*(x1 + x2 + x3))

    # Non-negativity
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)
    model.addConstr(x3 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Ads in DIY videos: {x1.varValue}")
        print(f"Ads in shopping videos: {x2.varValue}")
        print(f"Ads in unboxing videos: {x3.varValue}")
        print(f"Max Viewership: {model.objVal}")
    else:
        print("The model is infeasible")

solve_ad_optimization()
