
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Amazing_Arts")

    # Create variables
    large_artworks = model.addVar(vtype=gp.GRB.INTEGER, name="large_artworks")
    small_artworks = model.addVar(vtype=gp.GRB.INTEGER, name="small_artworks")


    # Set objective function
    model.setObjective(200 * large_artworks + 75 * small_artworks, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5 * large_artworks + 3 * small_artworks <= 200, "paint_constraint")
    model.addConstr(3 * large_artworks + 1 * small_artworks <= 100, "glitter_constraint")
    model.addConstr(4 * large_artworks + 2 * small_artworks <= 80, "glue_constraint")
    model.addConstr(large_artworks >= 5, "min_large_artworks")
    model.addConstr(small_artworks >= 10, "min_small_artworks")

    # Optimize model
    model.optimize()

    # Print results
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal Solution Found. Objective Value: {model.objVal}")
        print(f"Number of large artworks: {large_artworks.x}")
        print(f"Number of small artworks: {small_artworks.x}")
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {model.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
