
from gurobipy import *

# Create a new model
m = Model("Amazing_Arts")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="large_artworks")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="small_artworks")

# Set objective function
m.setObjective(200*x1 + 75*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 3*x2 <= 200, "paint_constraint")
m.addConstr(3*x1 + x2 <= 100, "glitter_constraint")
m.addConstr(4*x1 + 2*x2 <= 80, "glue_constraint")
m.addConstr(x1 >= 5, "min_large_artworks")
m.addConstr(x2 >= 10, "min_small_artworks")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of large artworks: {x1.x}")
    print(f"Number of small artworks: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
