
import gurobi

def solve_artwork_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=5, name="large_artworks")  # At least 5 large artworks
    x2 = model.addVar(lb=10, name="small_artworks")  # At least 10 small artworks

    # Objective function: Maximize 200*x1 + 75*x2
    model.setObjective(200*x1 + 75*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x1 + 3*x2 <= 200, name="paint_constraint")
    model.addConstr(3*x1 + x2 <= 100, name="glitter_constraint")
    model.addConstr(4*x1 + 2*x2 <= 80, name="glue_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of large artworks: {x1.varValue}")
        print(f"Number of small artworks: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_artwork_problem()
