
import gurobipy as gp

# Create a new model
m = gp.Model("camera_store")

# Create variables
lenses = m.addVar(vtype=gp.GRB.INTEGER, name="lenses")
tripods = m.addVar(vtype=gp.GRB.INTEGER, name="tripods")

# Set objective function
m.setObjective(200 * lenses + 150 * tripods, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(400 * lenses + 300 * tripods <= 10000, "budget")
m.addConstr(lenses >= 10, "min_lenses")
m.addConstr(lenses <= 25, "max_lenses")
m.addConstr(tripods <= (1/3) * lenses, "tripod_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of lenses to sell: {lenses.x}")
    print(f"Number of tripods to sell: {tripods.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

