
from gurobipy import *

# Create a new model
m = Model("Camera Store Optimization")

# Define the variables
x1 = m.addVar(name="lenses", lb=10, ub=25)
x2 = m.addVar(name="tripods")

# Set the objective function
m.setObjective(200*x1 + 150*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(400*x1 + 300*x2 <= 10000, name="budget")
m.addConstr(x2 <= (1/3)*x1, name="tripod_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of lenses: {x1.x}")
    print(f"Number of tripods: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
