
import gurobi

def solve_camera_store_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=10, ub=25, name="lenses")  # At least 10 lenses but at most 25
    x2 = model.addVar(name="tripods")

    # Objective function: Maximize 200*x1 + 150*x2
    model.setObjective(200*x1 + 150*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(400*x1 + 300*x2 <= 10000, name="budget_constraint")  # Budget constraint
    model.addConstr(x2 <= (1/3)*x1, name="tripod_lens_ratio_constraint")  # Tripod to lens ratio constraint

    # Update model
    model.update()

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Lenses: {x1.varValue}")
        print(f"Tripods: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_camera_store_problem()
