
import gurobipy as gp

# Create a new model
m = gp.Model("milk_production")

# Create variables
ice_cream = m.addVar(name="ice_cream")  # x1: units of ice cream
cheese = m.addVar(name="cheese")  # x2: units of cheese


# Set objective function
m.setObjective(2.5 * ice_cream + 4 * cheese, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(ice_cream <= 50, "ice_cream_production_limit")
m.addConstr(cheese <= 80, "cheese_production_limit")
m.addConstr(ice_cream + cheese <= 100, "machine_processing_limit")
m.addConstr(ice_cream >=0)
m.addConstr(cheese >=0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Units of ice cream: {ice_cream.x}")
    print(f"Units of cheese: {cheese.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

