
from gurobipy import *

# Create a new model
m = Model("Milk_Company_Problem")

# Create variables
x1 = m.addVar(lb=0, name="units_of_ice_cream")
x2 = m.addVar(lb=0, name="units_of_cheese")

# Set the objective function
m.setObjective(2.5*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 50, "ice_cream_production_limit")
m.addConstr(x2 <= 80, "cheese_production_limit")
m.addConstr(x1 + x2 <= 100, "shared_machine_capacity")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal production: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
