
import gurobipy as gp

# Create a new model
model = gp.Model("MilkCompanyProduction")

# Define the variables
x1 = model.addVar(name="ice_cream", lb=0, ub=50, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="cheese", lb=0, ub=80, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(2.5 * x1 + 4 * x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 50, name="ice_cream_production_limit")
model.addConstr(x2 <= 80, name="cheese_production_limit")
model.addConstr(x1 + x2 <= 100, name="total_production_limit")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Ice Cream Production: {x1.varValue}")
    print(f"Cheese Production: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or has no solution.")
