
import gurobipy as gp

# Create a new model
model = gp.Model("Chessboard Production")

# Create variables
small_chessboards = model.addVar(vtype=gp.GRB.INTEGER, name="small_chessboards")
large_chessboards = model.addVar(vtype=gp.GRB.INTEGER, name="large_chessboards")

# Set objective function
model.setObjective(4 * small_chessboards + 8 * large_chessboards, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * small_chessboards + 10 * large_chessboards <= 400, "Cutting Time")
model.addConstr(10 * small_chessboards + 20 * large_chessboards <= 700, "Assembly Time")
model.addConstr(small_chessboards >= 0, "Non-negative small chessboards")  # Explicit non-negativity constraints
model.addConstr(large_chessboards >= 0, "Non-negative large chessboards")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small chessboards: {small_chessboards.x}")
    print(f"Number of large chessboards: {large_chessboards.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

