
from gurobipy import *

# Create a new model
model = Model("Chessboard_Production")

# Define variables
x1 = model.addVar(name='x1', vtype=GRB.CONTINUOUS, lb=0)
x2 = model.addVar(name='x2', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
model.setObjective(4*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x1 + 10*x2 <= 400, name='cutting_time')
model.addConstr(10*x1 + 20*x2 <= 700, name='assembly_time')

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found")
