
import gurobipy as gp

# Create a new model
model = gp.Model("Chessboard_Production")

# Define the variables
x1 = model.addVar(name="small_chessboards", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="large_chessboards", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
model.setObjective(4 * x1 + 8 * x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * x1 + 10 * x2 <= 400, name="cutting_time")
model.addConstr(10 * x1 + 20 * x2 <= 700, name="assembly_time")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: small chessboards = {x1.varValue}, large chessboards = {x2.varValue}")
    print(f"Maximal profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
