
import gurobipy as gp

# Create a new model
m = gp.Model("fruit_bowls")

# Create variables
small_bowls = m.addVar(vtype=gp.GRB.CONTINUOUS, name="small_bowls")  # Number of small bowls
large_bowls = m.addVar(vtype=gp.GRB.CONTINUOUS, name="large_bowls")  # Number of large bowls


# Set objective function
m.setObjective(5 * small_bowls + 8 * large_bowls, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * small_bowls + 5 * large_bowls <= 100, "kiwi_constraint")
m.addConstr(2 * small_bowls + 4 * large_bowls <= 120, "mango_constraint")
m.addConstr(5 * small_bowls + 8 * large_bowls <= 150, "pineapple_constraint")
m.addConstr(small_bowls >=0)
m.addConstr(large_bowls >=0)


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small bowls: {small_bowls.x}")
    print(f"Number of large bowls: {large_bowls.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

