
from gurobipy import *

# Create a new model
m = Model("Tropical Fruit Bowls")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="small_bowls")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="large_bowls")

# Set the objective function
m.setObjective(5*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 <= 100, "kiwi")
m.addConstr(2*x1 + 4*x2 <= 120, "mango")
m.addConstr(5*x1 + 8*x2 <= 150, "pineapple")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Small bowls: {x1.x}")
    print(f"Large bowls: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
