
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="small_bowls")
    x2 = model.addVar(lb=0, name="large_bowls")

    # Define the objective function
    model.setObjective(5 * x1 + 8 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(3 * x1 + 5 * x2 <= 100, name="kiwi_constraint")
    model.addConstr(2 * x1 + 4 * x2 <= 120, name="mango_constraint")
    model.addConstr(5 * x1 + 8 * x2 <= 150, name="pineapple_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of small bowls to sell: {x1.varValue}")
        print(f"Number of large bowls to sell: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
