
import gurobipy as gp

# Create a new model
m = gp.Model("blanket_bedsheet_production")

# Create variables
blankets = m.addVar(vtype=gp.GRB.CONTINUOUS, name="blankets")
bedsheets = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bedsheets")

# Set objective function
m.setObjective(24 * blankets + 21 * bedsheets, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * blankets + 17 * bedsheets <= 2000, "cutting_time")
m.addConstr(12 * blankets + 14 * bedsheets <= 1500, "hemming_time")
m.addConstr(blankets >= 0, "blankets_nonnegative")
m.addConstr(bedsheets >= 0, "bedsheets_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of blankets: {blankets.x:.2f}")
    print(f"Number of bedsheets: {bedsheets.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

