
from gurobipy import *

# Create a model
m = Model("Blankets_and_Bedsheets")

# Add variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="blankets")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="bedsheets")

# Set the objective function
m.setObjective(24*x1 + 21*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*x1 + 17*x2 <= 2000, "cutting_time")
m.addConstr(12*x1 + 14*x2 <= 1500, "hemming_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Blankets: {x1.x}")
    print(f"Bedsheets: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
