
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="blankets", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="bedsheets", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Set the objective function
    model.setObjective(24 * x1 + 21 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(14 * x1 + 17 * x2 <= 2000, name="cutting_constraint")
    model.addConstr(12 * x1 + 14 * x2 <= 1500, name="hemming_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of blankets: {x1.varValue}")
        print(f"Number of bedsheets: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_problem()
