
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_acres") # Acres of apple trees
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="orange_acres") # Acres of orange trees

# Set objective function
m.setObjective(500*x1 + 450*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 80, "land_constraint") # Total land constraint
m.addConstr(30*x1 + 25*x2 <= 2200, "soil_constraint") # Soil constraint


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Plant {x1.x:.2f} acres of apple trees")
    print(f"Plant {x2.x:.2f} acres of orange trees")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

