
from gurobipy import *

# Create a new model
m = Model("Farmer_Profit")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="apple_trees", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="orange_trees", lb=0)

# Set the objective function
m.setObjective(500*x1 + 450*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 25*x2 <= 2200, "soil_limit")
m.addConstr(x1 + x2 <= 80, "land_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of apple trees: {x1.x}")
    print(f"Acres of orange trees: {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
