
import gurobi as grb

def solve_farmer_problem():
    # Create a new model
    model = grb.Model()

    # Define the variables
    x1 = model.addVar(name='apple_trees', lb=0, ub=80, obj=500)
    x2 = model.addVar(name='orange_trees', lb=0, ub=80, obj=450)

    # Add constraints
    model.addConstr(x1 + x2 <= 80, name='land_constraint')
    model.addConstr(30*x1 + 25*x2 <= 2200, name='soil_constraint')

    # Set the model to maximize the objective function
    model.optimize()

    # Print the results
    if model.status == grb.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Acres of apple trees: {x1.x}')
        print(f'Acres of orange trees: {x2.x}')
        print(f'Maximum profit: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_farmer_problem()
