
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("candy_mixture")

# Create variables
sour_drops = m.addVar(vtype=GRB.CONTINUOUS, name="sour_drops")
sour_belts = m.addVar(vtype=GRB.CONTINUOUS, name="sour_belts")


# Set objective function
m.setObjective(0.5 * sour_drops + 0.4 * sour_belts, GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * sour_drops + 4 * sour_belts >= 30, "sourness")
m.addConstr(4 * sour_drops + 3 * sour_belts >= 40, "flavoring")
m.addConstr(sour_belts <= 5, "sour_belts_limit")
m.addConstr(sour_drops >= 0, "sour_drops_nonnegative")  # Explicit non-negativity constraint
m.addConstr(sour_belts >= 0, "sour_belts_nonnegative")  # Explicit non-negativity constraint


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Number of sour drops: {sour_drops.x:.2f}")
    print(f"Number of sour belts: {sour_belts.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

