
from gurobipy import *

# Create a new model
m = Model("Candy_Mixture")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="sour_drops")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="sour_belts")

# Set the objective function
m.setObjective(0.5*x1 + 0.4*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 4*x2 >= 30, "Sourness_Constraint")
m.addConstr(4*x1 + 3*x2 >= 40, "Flavoring_Constraint")
m.addConstr(x2 <= 5, "Max_Sour_Belts_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of sour drops: {x1.x}")
    print(f"Number of sour belts: {x2.x}")
    print(f"Total cost: ${0.5*x1.x + 0.4*x2.x:.2f}")
else:
    print("No optimal solution found")
