
import gurobipy as gp

# Create a new model
model = gp.Model("Candy_Mixture")

# Define variables
x1 = model.addVar(name="sour_drops", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="sour_belts", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Minimize cost
model.setObjective(0.50 * x1 + 0.40 * x2, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(2 * x1 + 4 * x2 >= 30, name="sourness_constraint")
model.addConstr(4 * x1 + 3 * x2 >= 40, name="flavoring_constraint")
model.addConstr(x2 <= 5, name="sour_belts_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of sour drops: {x1.varValue}")
    print(f"Number of sour belts: {x2.varValue}")
    print(f"Optimal cost: {model.objVal}")
else:
    print("No optimal solution found.")
