
import gurobipy as gp

# Create a new model
m = gp.Model("toy_shop")

# Create variables
dolls = m.addVar(vtype=gp.GRB.CONTINUOUS, name="dolls")
soldiers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="soldiers")


# Set objective function
m.setObjective(8 * dolls + 10 * soldiers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * dolls + 15 * soldiers <= 1000, "crafting_time")
m.addConstr(5 * dolls + 8 * soldiers <= 800, "sanding_time")
m.addConstr(dolls >= 0, "dolls_nonnegative")  # Ensure non-negative values
m.addConstr(soldiers >= 0, "soldiers_nonnegative") # Ensure non-negative values

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of dolls: {dolls.x}")
    print(f"Number of soldiers: {soldiers.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

