
from gurobipy import *

# Create a new model
m = Model("Toy_Shop_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="dolls")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="soldiers")

# Set the objective function
m.setObjective(8*x1 + 10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 15*x2 <= 1000, "crafting_time")
m.addConstr(5*x1 + 8*x2 <= 800, "sanding_time")
m.addConstr(x1 >= 0, "non_negative_dolls")
m.addConstr(x2 >= 0, "non_negative_soldiers")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of dolls: {x1.x}")
    print(f"Number of soldiers: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
