
import gurobi

def solve_toy_shop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="dolls", lb=0, ub=None, obj=8)  # Number of dolls
    x2 = model.addVar(name="soldiers", lb=0, ub=None, obj=10)  # Number of soldiers

    # Add constraints
    model.addConstr(10*x1 + 15*x2 <= 1000, name="crafting_time")  # Crafting time constraint
    model.addConstr(5*x1 + 8*x2 <= 800, name="sanding_time")  # Sanding time constraint

    # Set the model objective
    model.setObjective(8*x1 + 10*x2, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Dolls: {x1.x}")
        print(f"Soldiers: {x2.x}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_toy_shop_problem()
