
import gurobipy as gp

# Create a new model
m = gp.Model("Berry_Farming")

# Create variables
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberries") # acres of blueberries
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="raspberries") # acres of raspberries


# Set objective function
m.setObjective(200*x1 + 250*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 300, "Land_Constraint")
m.addConstr(60*x1 + 40*x2 <= 20000, "Fertilizer_Constraint")
m.addConstr(3*x1 + 4*x2 <= 400, "Picking_Constraint")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal Solution:")
    print(f"Acres of Blueberries: {x1.x}")
    print(f"Acres of Raspberries: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")

