
from gurobipy import *

# Create a new model
m = Model("Berry_Farmer")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="blueberries", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="raspberries", lb=0)

# Set the objective function
m.setObjective(200*x1 + 250*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(60*x1 + 40*x2 <= 20000, "fertilizer_budget")
m.addConstr(3*x1 + 4*x2 <= 400, "picking_hours")
m.addConstr(x1 + x2 <= 300, "total_acres")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of blueberries: {x1.x}")
    print(f"Acres of raspberries: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
