
import gurobipy as gp

# Create a new model
m = gp.Model("berry_farmer")

# Define the variables
x1 = m.addVar(name="blueberries", lb=0)  # Acres of blueberries
x2 = m.addVar(name="raspberries", lb=0)  # Acres of raspberries

# Objective function: Maximize profit
m.setObjective(200*x1 + 250*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 300, name="land_constraint")  # Land constraint
m.addConstr(60*x1 + 40*x2 <= 20000, name="fertilizer_constraint")  # Fertilizer cost constraint
m.addConstr(3*x1 + 4*x2 <= 400, name="picking_time_constraint")  # Picking time constraint

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of blueberries: {x1.varValue}")
    print(f"Optimal acres of raspberries: {x2.varValue}")
    print(f"Maximal profit: {m.objVal}")
else:
    print("The model is infeasible.")
