
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("keyboard_production")

# Create variables
regular = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular")
mechanical = m.addVar(lb=0, vtype=GRB.INTEGER, name="mechanical")


# Set objective function
m.setObjective(30 * regular + 60 * mechanical, GRB.MAXIMIZE)

# Add constraints
m.addConstr(regular >= 165, "demand_regular")
m.addConstr(mechanical >= 70, "demand_mechanical")
m.addConstr(regular <= 300, "production_regular")
m.addConstr(mechanical <= 150, "production_mechanical")
m.addConstr(regular + mechanical >= 250, "contract")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Regular keyboards: {regular.x}")
    print(f"Mechanical keyboards: {mechanical.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

