
from gurobipy import *

# Create a new model
m = Model("Keyboard_Production")

# Define variables
x1 = m.addVar(name="regular_keyboards", lb=0)
x2 = m.addVar(name="mechanical_keyboards", lb=0)

# Set objective function
m.setObjective(30*x1 + 60*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 165, name="demand_regular")
m.addConstr(x2 >= 70, name="demand_mechanical")
m.addConstr(x1 <= 300, name="limit_regular")
m.addConstr(x2 <= 150, name="limit_mechanical")
m.addConstr(x1 + x2 >= 250, name="total_production")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular keyboards: {x1.x}")
    print(f"Mechanical keyboards: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
