
import gurobi

def solve_keyboard_factory_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="regular_keyboards", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=0, name="mechanical_keyboards", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 30*x1 + 60*x2
    model.setObjective(30*x1 + 60*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 >= 165, name="demand_regular")
    model.addConstr(x2 >= 70, name="demand_mechanical")
    model.addConstr(x1 <= 300, name="production_limit_regular")
    model.addConstr(x2 <= 150, name="production_limit_mechanical")
    model.addConstr(x1 + x2 >= 250, name="contract_requirement")

    # Update the model
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Regular keyboards: {x1.varValue}")
        print(f"Mechanical keyboards: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_keyboard_factory_problem()
