
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("aquarium_feed")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bag_A") # Bags of A
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bag_B") # Bags of B


# Set objective function
m.setObjective(4*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 4*x2 >= 20, "Sardines")
m.addConstr(3*x1 + x2 >= 25, "Anchovies")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Bags of A: {x1.x:.2f}")
    print(f"Bags of B: {x2.x:.2f}")

