
from gurobipy import *

# Create a new model
model = Model("Aquarium_Feeding")

# Define variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="bags_A")
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="bags_B")

# Set the objective function
model.setObjective(4*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints
model.addConstr(2*x1 + 4*x2 >= 20, "sardines_constraint")
model.addConstr(3*x1 + x2 >= 25, "anchovies_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bags of type A: {x1.x}")
    print(f"Number of bags of type B: {x2.x}")
    print(f"Total cost: {model.objVal}")
else:
    print("No optimal solution found")
