
import gurobi

def solve_aquarium_feeding_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # bags of type A
    x2 = model.addVar(name="x2", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # bags of type B

    # Objective function: minimize 4*x1 + 6*x2
    model.setObjective(4*x1 + 6*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2*x1 + 4*x2 >= 20, name="sardines_constraint")
    model.addConstr(3*x1 + x2 >= 25, name="anchovies_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of bags of type A: {x1.varValue}")
        print(f"Number of bags of type B: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_aquarium_feeding_problem()
