
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("fruit_farm")

# Create variables
x1 = m.addVar(lb=0, name="days_farm1")
x2 = m.addVar(lb=0, name="days_farm2")

# Set objective function
m.setObjective(500*x1 + 400*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x1 + 7*x2 >= 50, "apples")
m.addConstr(15*x1 + 8*x2 >= 60, "oranges")
m.addConstr(5*x1 + 9*x2 >= 55, "pears")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: {m.objVal}")
    print(f"Days to operate farm 1: {x1.x}")
    print(f"Days to operate farm 2: {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

