
from gurobipy import *

# Create a new model
m = Model("Fruit_Farm_Optimization")

# Define the variables
x1 = m.addVar(name='x1', lb=0)
x2 = m.addVar(name='x2', lb=0)

# Set the objective function
m.setObjective(500*x1 + 400*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x1 + 7*x2 >= 50, name='apples_constraint')
m.addConstr(15*x1 + 8*x2 >= 60, name='oranges_constraint')
m.addConstr(5*x1 + 9*x2 >= 55, name='pears_constraint')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
