
import gurobipy as gp

# Create a new model
model = gp.Model("FruitFarmer")

# Define the variables
x1 = model.addVar(name="farm1_days", lb=0)  # days to operate farm 1
x2 = model.addVar(name="farm2_days", lb=0)  # days to operate farm 2

# Define the objective function
model.setObjective(500 * x1 + 400 * x2, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(10 * x1 + 7 * x2 >= 50, name="apples_constraint")
model.addConstr(15 * x1 + 8 * x2 >= 60, name="oranges_constraint")
model.addConstr(5 * x1 + 9 * x2 >= 55, name="pears_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Days to operate farm 1: {x1.varValue}")
    print(f"Days to operate farm 2: {x2.varValue}")
    print(f"Total cost: {model.objVal}")
else:
    print("No optimal solution found.")
