
import gurobipy as gp

# Create a new model
m = gp.Model("kayak_canoe")

# Create variables
kayaks = m.addVar(vtype=gp.GRB.CONTINUOUS, name="kayaks")
canoes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="canoes")

# Set objective function
m.setObjective(300 * kayaks + 450 * canoes, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(60 * kayaks + 80 * canoes <= 8000, "assembly_time")
m.addConstr(15 * kayaks + 25 * canoes <= 4000, "quality_check_time")
m.addConstr(kayaks >= 0, "kayaks_nonnegative")
m.addConstr(canoes >= 0, "canoes_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of kayaks: {kayaks.x}")
    print(f"Number of canoes: {canoes.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

