
from gurobipy import *

# Create a new model
m = Model("Kayak_Canoe_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="kayaks")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="canoes")

# Set the objective function
m.setObjective(300*x1 + 450*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(60*x1 + 80*x2 <= 8000, "assembly_time")
m.addConstr(15*x1 + 25*x2 <= 4000, "quality_checking_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of kayaks: {x1.x}")
    print(f"Number of canoes: {x2.x}")
    print(f"Total profit: ${300*x1.x + 450*x2.x:.2f}")
else:
    print("No optimal solution found")
