
import gurobipy as gp

# Create a new model
model = gp.Model("Kayak_Canoe_Production")

# Define the variables
x1 = model.addVar(name="kayaks", lb=0, vtype=gp.GRB.INTEGER)  # Number of kayaks
x2 = model.addVar(name="canoes", lb=0, vtype=gp.GRB.INTEGER)  # Number of canoes

# Define the objective function
model.setObjective(300*x1 + 450*x2, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(60*x1 + 80*x2 <= 8000, name="assembly_time")
model.addConstr(15*x1 + 25*x2 <= 4000, name="quality_checking_time")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of kayaks: {x1.varValue}")
    print(f"Optimal number of canoes: {x2.varValue}")
    print(f"Maximal profit: {model.objVal}")
else:
    print("The model is infeasible")
